#include "kk_test.h"
#include "kk_sub_tsl.h"
#include "kk_tsl_zigbee_map.h"

extern kk_tsl_zigbee_map_t g_tsl_zigbee_map [];

static void kk_rpc_send_message(cJSON *data,char *msgtype,char *method,EmberEUI64 mac)
{
	static uint16_t msgid;
	char msgIdString[10]= {0};
	char macString[19] = {0};

	cJSON *info = rpc_cJSON_CreateObject();
	if(info != NULL){
		rpc_cJSON_AddStringToObject(info, "msgType",msgtype);
		rpc_cJSON_AddStringToObject(info, "productCode","24");
		rpc_eui64ToString(mac,macString);
		rpc_cJSON_AddStringToObject(info, "deviceCode",macString);	
	}
	cJSON *payload = rpc_cJSON_CreateObject();
	if(payload != NULL){
		sprintf(msgIdString,"%d",++msgid);
		rpc_cJSON_AddStringToObject(payload, "msgId",msgIdString);
		rpc_cJSON_AddStringToObject(payload, "version", KK_IPC_VERSION);
		rpc_cJSON_AddStringToObject(payload, "method",method);
		rpc_cJSON_AddItemToObject(payload, "params", data);		
	}
	cJSON *root = rpc_cJSON_CreateObject();
	if(root != NULL){
		rpc_cJSON_AddItemToObject(root, "info", info);	
		rpc_cJSON_AddItemToObject(root, "payload", payload);	
	}

	char* p = rpc_cJSON_Print(root);
	emberAfAppPrintln("send json:\n%s\n",p);
	free(p);
	jrpc_send_msg(root);	
	rpc_cJSON_Delete(root);	
}
void kk_rpc_report_devices(cJSON *data,EmberEUI64 mac)
{
	kk_rpc_send_message(data,KK_REPORT_DEVICE_JOINED_TYPE,KK_REPORT_DEVICE_JOINED_METHOD,mac);
}
void kk_rpc_report_status(cJSON *data,EmberEUI64 mac)
{
	kk_rpc_send_message(data,KK_REPORT_ATTRIBUTE_TYPE,KK_REPORT_ATTRIBUTE_METHOD,mac);
}

typedef struct{
	EmberEUI64 mac;
	uint8_t AppVersion;
	uint8_t deviceType;
	uint8_t deviceCode;
	uint8_t productType;
	uint8_t productCode;
}kk_report_device_s;



void kk_rpc_reportDevices(kk_report_device_s device)
{
	cJSON* devicesJson;

	devicesJson = rpc_cJSON_CreateObject();
	
	rpc_cJSON_AddAppVersionToObject(devicesJson,device.AppVersion); 
	rpc_cJSON_AddStringToObject(devicesJson, "deviceType","1");
	rpc_cJSON_AddStringToObject(devicesJson, "deviceCode","2");
	rpc_cJSON_AddStringToObject(devicesJson, "productType","3");
	rpc_cJSON_AddStringToObject(devicesJson, "productCode",TEST_PRODUCT_CODE);
	kk_sub_tsl_add(device.mac,TEST_PRODUCT_CODE);
	kk_rpc_report_devices(devicesJson,device.mac);
}
int kk_rpc_report_LightStatus(EmberEUI64 mac,int status,uint16_t clusterId,uint16_t attributeId)
{
	cJSON* root;
	int res = 0;
	int num = 0;
	int pCtrlIdx = 0;
	uint16_t clusterId_tmp = 0;
	uint16_t attributeId_tmp = 0;
	int i = 0;
	sub_dev_node_t *node = NULL;
	char macString[RPC_EUI64_STRING_LENGTH];
	rpc_eui64ToString(mac,macString);

	root = rpc_cJSON_CreateObject();

	res = kk_sub_tsl_get_device_by_mac(macString, &node);
	if (res != SUCCESS_RETURN) {
		printf("[%s][%d]\n",__FUNCTION__,__LINE__);
		return -1;
	}	
	pCtrlIdx = kk_find_ctrl_obj(node->productCode);
	if(pCtrlIdx == -1){
		printf("[%s][%d]\n",__FUNCTION__,__LINE__);		
		return -1;
	}
	num = kk_get_Identity_Num(pCtrlIdx);
	for(i = 0; i < num; i++)
	{
		clusterId_tmp = g_tsl_zigbee_map[pCtrlIdx].zigbee_ctrl[i].clusterId;
		attributeId_tmp = g_tsl_zigbee_map[pCtrlIdx].zigbee_ctrl[i].attributeId;
		if(clusterId_tmp == clusterId && attributeId_tmp == attributeId)
		{
			rpc_cJSON_AddNumberToObject(root, g_tsl_zigbee_map[pCtrlIdx].zigbee_ctrl[i].Identity,status);
			break;
		}
	}
	kk_rpc_report_status(root,mac);
	return 0;
}
int lightStatusSet(jrpc_context * ctx,const char *mac,void* data)
{
	uint8_t eui64[EUI64_SIZE];
    uint8_t LightStatus	= 0;
	EmberStatus status = 0;

	LightStatus = *(uint8_t*)data;
	bool flag= rpc_get_mac(mac,eui64);
	emberAfCorePrintBuffer(eui64,EUI64_SIZE,true);
	for(int i=0;i<EUI64_SIZE;i++){
		emberAfCorePrintln("i=%d,val=%02x",i,eui64[i]);
	}

	EmberNodeId node = emberAfDeviceTableGetNodeIdFromEui64(eui64);
	if(node==0xffff){
		emberAfCorePrintln("\r\n not find device!\r\n" );
		if(ctx)
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}
	emberAfCorePrintln("\r\nnode=0x%02X,LightStatus=%d\r\n",node,LightStatus);
	if(flag){

		if(LightStatus==1){
			status = zclOnOff_On(node,1);
			emberAfCorePrintln("\r\nzclOnOff_On\r\n" );
		}else if(LightStatus==0){
			status = zclOnOff_Off(node,1);
			emberAfCorePrintln("\r\nzclOnOff_Off\r\n" );
		}else{
			if(ctx)
				set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			goto error_return;
		}
	}else{
		emberAfCorePrintln("\r\n22222\r\n" );
		if(ctx)
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}	
	return status;
error_return:
	return -1;


}
#if 0
int kk_test_fuc(char *mac,const char *params)
{
    sub_dev_node_t *node = NULL;
	int res = 0;
	int pCtrlIdx = 0;	
	int num  =0;
	int index = 0;
	cJSON *propertyItem = NULL;
	cJSON *root;	
	root=cJSON_Parse((char*)params);
	res = kk_sub_tsl_get_device_by_mac(mac, &node);
	if (res != SUCCESS_RETURN) {
		printf("[%s][%d]\n",__FUNCTION__,__LINE__);
	
	}
	printf("[%s][%d]node->product_type:%s\n",__FUNCTION__,__LINE__,node->product_type);
	pCtrlIdx = kk_find_ctrl_obj(node->product_type);
	if(pCtrlIdx == -1){
		printf("[%s][%d]\n",__FUNCTION__,__LINE__);		
	}
	printf("[%s][%d]\n",__FUNCTION__,__LINE__);
	num = kk_get_Identity_Num(pCtrlIdx);
	printf("[%s][%d]\n",__FUNCTION__,__LINE__);
	for(index = 0; index < num; index++){
		printf("[%s][%d]\n",__FUNCTION__,__LINE__);
		printf("[%s][%d]------->%s\n",__FUNCTION__,__LINE__,g_tsl_zigbee_map[pCtrlIdx].zigbee_ctrl[index].Identity);
		//kk_sub_tsl_get_Identifier_by_index(mac,index,&identifier);
		propertyItem = rpc_cJSON_GetObjectItem(root, g_tsl_zigbee_map[pCtrlIdx].zigbee_ctrl[index].Identity);
		printf("[%s][%d]\n",__FUNCTION__,__LINE__);
		if(propertyItem != NULL)
		{
			int value = rpc_get_u8(propertyItem->valuestring);
			printf("[%s][%d]value:%d\n",__FUNCTION__,__LINE__,value);
			res = g_tsl_zigbee_map[pCtrlIdx].zigbee_ctrl[index].zigbee_set(NULL,mac,&value);
			if(res < 0)
{
				printf("[%s][%d]\n",__FUNCTION__,__LINE__);
				return -1;
			}
			else{
				printf("[%s][%d]\n",__FUNCTION__,__LINE__);
				return 0;
			}
		}
	}	
	return 0;

}
#endif
cJSON *rpc_read_attribue(jrpc_context * ctx, cJSON *params, cJSON *id,cJSON *mac)
{
	rpc_nwk_info_s info;
	EmberStatus status;
	int num = 0,index = 0;
    cJSON *propertyItem = NULL;
    sub_dev_node_t *node = NULL;
	int pCtrlIdx = 0;
	int res = 0,ret = 0;
	if(params == NULL){
		emberAfCorePrintln("\r\nparams == NULL\r\n" );
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else{
		res = kk_sub_tsl_get_device_by_mac(mac->valuestring, &node);
		if (res != SUCCESS_RETURN) {
			goto error_return;

		}
		pCtrlIdx = kk_find_ctrl_obj(node->productCode);
		if(pCtrlIdx < SUCCESS_RETURN){
			goto error_return;
		}		
		num = kk_get_Identity_Num(pCtrlIdx);		
		for(index = 0; index < num; index++){
			
			propertyItem = rpc_cJSON_GetObjectItem(params, g_tsl_zigbee_map[pCtrlIdx].zigbee_ctrl[index].Identity);
			if(propertyItem != NULL)
			{
				int value = rpc_get_u8(propertyItem->valuestring);
				res = g_tsl_zigbee_map[pCtrlIdx].zigbee_ctrl[index].zigbee_set(ctx,mac->valuestring,&value);
				if(ret < 0)
{
					goto error_return;
				}
				else{
					return rpc_cJSON_CreateNumber(ret);
				}
				
			}
		}
	}
error_return:
	return rpc_cJSON_CreateNull();

}


cJSON *rpc_Control(jrpc_context * ctx, cJSON *params, cJSON *id,cJSON *mac)
{
    sub_dev_node_t *node = NULL;
	int res = 0;
	int num = 0;
	int pCtrlIdx = 0;	
	rpc_nwk_info_s info;
	EmberStatus status;
	int index = 0;
    cJSON *propertyItem = NULL;

	if(params == NULL){
		emberAfCorePrintln("\r\nparams == NULL\r\n" );
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else{
		res = kk_sub_tsl_get_device_by_mac(mac->valuestring, &node);
		if (res != SUCCESS_RETURN) {
			printf("[%s][%d]\n",__FUNCTION__,__LINE__);
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			goto error_return;
		}
		pCtrlIdx = kk_find_ctrl_obj(node->productCode);
		if(pCtrlIdx == -1){
			printf("[%s][%d]\n",__FUNCTION__,__LINE__);
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			goto error_return;
		}	
		num = kk_get_Identity_Num(pCtrlIdx);		
		for(index = 0; index < num; index++){	
			propertyItem = rpc_cJSON_GetObjectItem(params, g_tsl_zigbee_map[pCtrlIdx].zigbee_ctrl[index].Identity);
			if(propertyItem != NULL)
			{		
				int value = rpc_get_u8(propertyItem->valuestring);
				res = g_tsl_zigbee_map[pCtrlIdx].zigbee_ctrl[index].zigbee_set(ctx,mac->valuestring,&value);
				if(res < 0)
{
					set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
					goto error_return;
				}
				else{
					return rpc_cJSON_CreateNumber(res);
				}			
			}
		}
	}
error_return:
	return rpc_cJSON_CreateNull();
}

cJSON *rpc_nwkPermitJoin(jrpc_context * ctx, cJSON * params, cJSON *id)
{
	cJSON * OpenOrClose;
	EmberStatus status;
	uint8_t isEnable;
	
	if(params == NULL){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else if(params->type == cJSON_Object){
		OpenOrClose = rpc_cJSON_GetObjectItem(params, "NetChannelState");
	}else{
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}

	isEnable = rpc_get_u8(OpenOrClose->valuestring);

	if(isEnable == 0){
		status = nwkPermitJoinCMD(FALSE);
		emberAfCorePrintln("Disable Permit join\r\n");
	}else if(isEnable == 1){
		status = nwkPermitJoinCMD(TRUE);
		emberAfCorePrintln("Enable Permit join 180s\r\n");
	}else{
		emberAfCorePrintln("item type error[%d]\r\n",OpenOrClose->type);
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}

	return rpc_cJSON_CreateNumber(status);
	
	error_return:
	return rpc_cJSON_CreateNull();

}





void emberAfPluginDeviceTableNewDeviceCallback(EmberEUI64 nodeEui64)
{
	uint16_t deviceTableIndex = emberAfDeviceTableGetFirstIndexFromEui64(nodeEui64);
	if(deviceTableIndex == 0xffff){
		kk_print_info("not find item!");
		return ;
	}

	//EmberAfPluginDeviceTableEntry *deviceTable = emberAfDeviceTablePointer();

	//cJSON* nodeJson = rpc_reportDeviceState("joined",deviceTable[deviceTableIndex].eui64);
	//rpc_printfJSON("joined",nodeJson);
	//rpc_send_message(nodeJson,"device joined");

	//rpc_add_device(deviceTable[deviceTableIndex].nodeId);

	kk_report_device_s device;
	//device.mac = nodeEui64;
	device.AppVersion = 0x10;
	memcpy(device.mac,nodeEui64,EUI64_SIZE);
	kk_rpc_reportDevices(device);
}

