#include "kk_sub_tsl.h"


typedef unsigned char EmberEUI64[8];

typedef struct {
    void *mutex;
	int sub_devid;
    struct list_head dev_list;	
} kk_sub_dev_ctx_t;

static kk_sub_dev_ctx_t g_sub_dev_mgr = {0};
static kk_sub_dev_ctx_t * _sub_dev_get_ctx(void)
{
    return &g_sub_dev_mgr;
}

static void _sub_dev_mutex_lock(void)
{
    kk_sub_dev_ctx_t *ctx = _sub_dev_get_ctx();
    if (ctx->mutex) {
        HAL_MutexLock(ctx->mutex);
    }
}

static void _sub_dev_mutex_unlock(void)
{
    kk_sub_dev_ctx_t *ctx = _sub_dev_get_ctx();
    if (ctx->mutex) {
        HAL_MutexUnlock(ctx->mutex);
    }
}

int kk_tsl_init(EmberEUI64 mac)
{
	int res = 0;
	kk_sub_dev_ctx_t *ctx = _sub_dev_get_ctx();
    ctx->mutex = HAL_MutexCreate();
    if (ctx->mutex == NULL) {
        return FAIL_RETURN;
    }	
    ctx->sub_devid = 1;
    INIT_LIST_HEAD(&ctx->dev_list);	
	kk_sub_tsl_add(mac,"2");

	//usleep(1000000);
	//kk_test();
	return SUCCESS_RETURN;
}
static int _kk_tsl_check_exist(const char *deviceCode)
{
    sub_dev_node_t *search_node = NULL;
	kk_sub_dev_ctx_t *ctx = _sub_dev_get_ctx();

	if(deviceCode == NULL){
		return  INVALID_PARAMETER;
	}
    list_for_each_entry(search_node, &ctx->dev_list, linked_list, sub_dev_node_t) {
        if ( (strlen(search_node->deviceCode) == strlen(deviceCode)) &&
            (memcmp(search_node->deviceCode, deviceCode, strlen(deviceCode)) == 0)) {
            /* dm_log_debug("Device Found, Product Key: %s, Device Name: %s", product_key, device_name); */
            return SUCCESS_RETURN;
        }
    }
	return FAIL_RETURN;
}
int kk_sub_tsl_add(EmberEUI64 device_mac,const char *productCode)
{
    sub_dev_node_t *node = NULL;
	kk_sub_dev_ctx_t *ctx = _sub_dev_get_ctx();
	char *tsl_str = NULL;
	int res = 0;
	char macString[19] = {0};
	if(productCode == NULL)
	{
		return INVALID_PARAMETER;
	}

	rpc_eui64ToString(device_mac,macString);
	if(_kk_tsl_check_exist(device_mac) == SUCCESS_RETURN){
		return SUCCESS_RETURN;
	}
    node = malloc(sizeof(sub_dev_node_t));
    if (node == NULL) {
        return MEMORY_NOT_ENOUGH;
    }
	_sub_dev_mutex_lock();
	memset(node,0,sizeof(sub_dev_node_t) );
	memcpy(node->deviceCode, macString, strlen(macString));
	memcpy(node->productCode, productCode, strlen(productCode));

    INIT_LIST_HEAD(&node->linked_list);
    list_add_tail(&node->linked_list, &ctx->dev_list);
	_sub_dev_mutex_unlock();	
	return SUCCESS_RETURN;
}
int kk_sub_tsl_delete(EmberEUI64 device_mac)
{
    sub_dev_node_t *node = NULL;
	kk_sub_dev_ctx_t *ctx = _sub_dev_get_ctx();
	char *tsl_str = NULL;
	int res = 0;
	char macString[19] = {0};


	rpc_eui64ToString(device_mac,macString);
	_sub_dev_mutex_lock();	
    res = kk_sub_tsl_get_device_by_mac(macString, &node);
    if (res != SUCCESS_RETURN) {
		_sub_dev_mutex_unlock();
        return FAIL_RETURN;
    }
    list_del(&node->linked_list);
	free(node);
	node = NULL;
	_sub_dev_mutex_unlock();	
	return SUCCESS_RETURN;
}

int kk_sub_tsl_get_device_by_mac(_IN_ const char *deviceCode , _OU_ sub_dev_node_t **node)
{
    kk_sub_dev_ctx_t *ctx = _sub_dev_get_ctx();
    sub_dev_node_t *search_node = NULL;

    list_for_each_entry(search_node, &ctx->dev_list, linked_list, sub_dev_node_t) {
        if ((strlen(search_node->deviceCode) == strlen(deviceCode)) &&
            (memcmp(search_node->deviceCode, deviceCode, strlen(deviceCode)) == 0)) {
            if (node) {
                *node = search_node;
            }
            return SUCCESS_RETURN;
        }
    }

    printf("Device Not Found, device_mac: %s\n", deviceCode);
    return FAIL_RETURN;
}

