#include "kk_zigbee_api.h"


// network leave
EmberStatus kk_network_leave(void)
{
	EmberStatus status = ezspLeaveNetwork();
	
	if (status == EMBER_SUCCESS) {
		emberAfAppPrintln("net_leave: Left network\r\n");
	} else {
		emberAfAppPrintln("net_leave: Error 0x%X\r\n", status);
	}
	return status;
}
EmberStatus kk_network_form(bool centralized,EmberPanId panId,int8_t radioTxPower,uint8_t channel)
{
	EmberStatus status = emberAfPluginNetworkCreatorNetworkForm(centralized,
																panId,
																radioTxPower,
																channel);

																

	emberAfAppPrintln("[network form]centralized:%p,PAN ID:0x%2x,TxPower:%d,channel:0x%x,status=0x%x",
						(centralized==true)?"yes":"no",
						panId,
						radioTxPower,
						channel,
						status);
	return status;
}

void kk_print_network_info(void)
{
	emberAfAppPrint("\r\nMAC Address			= " );
	EmberEUI64 eui64;
	emberAfGetEui64(eui64);
	emberAfPrintBigEndianEui64(eui64);
	emberAfAppFlush();
	EmberNetworkStatus status = ezspNetworkState();

	if (status== EMBER_JOINED_NETWORK ){
		emberAfAppPrintln("\r\nNode ID			= 0x%2x", 	emberAfGetNodeId() );
		emberAfAppPrintln("\r\nPANID			= 0x%2x", 	emberAfGetPanId() );
		emberAfAppPrintln("\r\nChannel			= 0x%x",		emberAfGetRadioChannel() );
		emberAfAppPrintln("\r\nTX Power(dBm)	= %d", 	emberAfGetRadioChannel() );
		emberAfAppFlush();
	
		EmberKeyStruct nwkKey;
			
		if ( emberGetKey(EMBER_CURRENT_NETWORK_KEY,&nwkKey) == EMBER_SUCCESS )
		{
			emberAfAppPrintln("\r\nNetwork Key	 = " );
			emberAfPrintZigbeeKey(emberKeyContents(&nwkKey.key));
			emberAfAppFlush();
		}
		
	}else{
		emberAfAppPrintln( "\r\nNot joined network: Network Satus: 0x%x\r\n", status );
	}
}


EmberStatus kk_zdo_leave_request(EmberNodeId target,bool removeChildren,bool rejoin)
{
	EmberEUI64 nullEui64 = { 0, 0, 0, 0, 0, 0, 0, 0 };
	EmberStatus status;

	uint8_t options = 0;
	if (rejoin) {
		options |= EMBER_ZIGBEE_LEAVE_AND_REJOIN;
	}
	if (removeChildren) {
		options |= EMBER_ZIGBEE_LEAVE_AND_REMOVE_CHILDREN;
	}

	status = emberLeaveRequest(target,
								nullEui64,
								options,
								EMBER_APS_OPTION_RETRY);

	emberAfAppPrintln("Leave %p0x%X", "Request: ", status);
}


EmberStatus zclGRead(uint16_t node,
				uint8_t srcEP,
				uint8_t dstEP,
				bool multicast,
				uint16_t clusterId,
				uint16_t attrId,
				bool svr)
{
	EmberStatus status;

	zclBufferSetup(ZCL_GLOBAL_COMMAND | ((svr==true)?
											ZCL_FRAME_CONTROL_CLIENT_TO_SERVER
											:ZCL_FRAME_CONTROL_SERVER_TO_CLIENT),
					clusterId,
					ZCL_READ_ATTRIBUTES_COMMAND_ID);
	
	zclBufferAddByte(LOW_BYTE(attrId));
	zclBufferAddByte(HIGH_BYTE(attrId));

	rpcBufferPrint();
	status = rpcSendCommand(node,srcEP,dstEP,multicast);
	return status;
}

EmberStatus zclGWrite(uint16_t node,
				uint8_t srcEP,
				uint8_t dstEP,
				bool multicast,
				uint16_t clusterId,
				uint16_t attrId,
				uint8_t dataType,
				uint8_t dataLen,
				uint8_t *data,
				bool svr)
{
	EmberStatus status = EMBER_ERR_FATAL;
	int i;
	if(data==NULL||dataLen==0) return status;

	zclBufferSetup(ZCL_GLOBAL_COMMAND | ((svr==true)?
											ZCL_FRAME_CONTROL_CLIENT_TO_SERVER
											:ZCL_FRAME_CONTROL_SERVER_TO_CLIENT),
					clusterId,
					ZCL_WRITE_ATTRIBUTES_COMMAND_ID);
	
	zclBufferAddByte(LOW_BYTE(attrId));
	zclBufferAddByte(HIGH_BYTE(attrId));
	zclBufferAddByte(dataType);
	for(i=0;i<dataLen;i++){
		zclBufferAddByte(data[i]);
	}

	rpcBufferPrint();
	status = rpcSendCommand(node,srcEP,dstEP,multicast);
	return status;
}

//
EmberStatus WindowCover_UpOpen(uint16_t node,uint8_t ep)
{
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_WINDOW_COVERING_CLUSTER_ID,
									ZCL_WINDOW_COVERING_UP_OPEN_COMMAND_ID);

	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Up/Open]node=0x%02X,ep=%d,status=0x%02X\n",node,ep,status);
	return status;
}
EmberStatus WindowCover_DownClose(uint16_t node,uint8_t ep)
{
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_WINDOW_COVERING_CLUSTER_ID,
									ZCL_WINDOW_COVERING_DOWN_CLOSE_COMMAND_ID);

	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Down/Close]node=0x%02X,ep=%d,status=0x%02X\n",node,ep,status);
	return status;
}
EmberStatus WindowCover_Stop(uint16_t node,uint8_t ep)
{
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_WINDOW_COVERING_CLUSTER_ID,
									ZCL_WINDOW_COVERING_STOP_COMMAND_ID);

	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Stop]node=0x%02X,ep=%d,status=0x%02X\n",node,ep,status);
	return status;
}

EmberStatus WindowCover_GotoLiftPercentage(uint16_t node,uint8_t ep,uint8_t position)
{
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_WINDOW_COVERING_CLUSTER_ID,
									ZCL_WINDOW_COVERING_GO_TO_LIFT_PERCENTAGE_COMMAND_ID);
	zclBufferAddByte(position);

	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[GotoLiftPercentage]node=0x%02X,ep=%d,status=0x%02X\n",node,ep,status);
	return status;
}

EmberStatus zclOnOff_On(uint16_t node,uint8_t ep)
{
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_ON_OFF_CLUSTER_ID,
									ZCL_ON_COMMAND_ID);

	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[On]node=0x%02X,ep=%d,status=0x%02X\n",node,ep,status);
	return status;
}

EmberStatus zclOnOff_Off(uint16_t node,uint8_t ep)
{
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_ON_OFF_CLUSTER_ID,
									ZCL_OFF_COMMAND_ID);

	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Off]node=0x%02X,ep=%d,status=0x%02X\n",node,ep,status);
	return status;
}
EmberStatus zclOnOff_Toggle(uint16_t node,uint8_t ep)
{
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_ON_OFF_CLUSTER_ID,
									ZCL_TOGGLE_COMMAND_ID);

	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Toggle]node=0x%02X,ep=%d,status=0x%02X\n",node,ep,status);
	return status;
}
EmberStatus zclOnOff_OffWithEffect(uint16_t node,uint8_t ep,uint8_t id,uint8_t var)
{
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_ON_OFF_CLUSTER_ID,
									ZCL_OFF_WITH_EFFECT_COMMAND_ID);

	zclBufferAddByte(id);
	zclBufferAddByte(var);

	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[off with effect]node=0x%02X,ep=%d,status=0x%02X\n",node,ep,status);
	return status;
}

EmberStatus zclOnOff_OnWithRecallGlobalScene(uint16_t node,uint8_t ep)
{
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_ON_OFF_CLUSTER_ID,
									ZCL_ON_WITH_RECALL_GLOBAL_SCENE_COMMAND_ID);

	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[On with recall global scene]node=0x%02X,ep=%d,status=0x%02X\n",node,ep,status);
	return status;
}

EmberStatus zclOnOff_OnWithTimedOff(uint16_t node,uint8_t ep,uint8_t Control,uint16_t OnTime,uint16_t OffWaitTime)
{
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_ON_OFF_CLUSTER_ID,
									ZCL_ON_WITH_TIMED_OFF_COMMAND_ID);

	zclBufferAddByte(Control);
	zclBufferAddWord(OnTime);
	zclBufferAddWord(OffWaitTime);

	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[on with timed off]node=0x%02X,ep=%d,status=0x%02X\n",node,ep,status);
	return status;
}

EmberStatus zclColorControlMovetohue(uint16_t node,
										uint8_t ep,
										uint8_t hue,
										uint8_t dir,
										uint16_t trsTime,
										bool options,
										uint8_t mask,
										uint8_t Override) {

	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_MOVE_TO_HUE_COMMAND_ID);
	zclBufferAddByte(hue);
	zclBufferAddByte(dir);
	zclBufferAddWord(trsTime);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}
	
	kk_print_debug("hue=%d,dir=%d,trsTime=%d,mask=%d,Override=%d\r\n",
					hue,dir,trsTime,mask,Override);
	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Move to hue]status=0x%02X\n",status);


	return status;
}
EmberStatus zclColorControlMovehue(uint16_t node,
										uint8_t ep,
										uint8_t mode,
										uint8_t rate,
										bool options,
										uint8_t mask,
										uint8_t Override) {
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_MOVE_HUE_COMMAND_ID);
	zclBufferAddByte(mode);
	zclBufferAddByte(rate);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}
	emberAfCorePrintln("mode=0x%02x,rate=0x%02x,mask=0x%02x,Override=0x%02x\r\n",
						mode,rate,mask,Override);
	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Move hue]status=0x%02X\n",status);
	return status;
}
EmberStatus zclColorControlStephue(uint16_t node,
											uint8_t ep,
											uint8_t mode,
											uint8_t size,
											uint8_t trsTime,
											bool options,
											uint8_t mask,
											uint8_t Override) {
	EmberStatus status;

	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_STEP_HUE_COMMAND_ID);
	
	zclBufferAddByte(mode);
	zclBufferAddByte(size);
	zclBufferAddByte(trsTime);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}
	
	emberAfCorePrintln("step mode=%d,step size=%d,transition time=%d,mask=%d,override=%d\r\n",
					mode,size,trsTime,mask,Override);
	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Step hue]status=0x%02X\n",status);
	return status;
}
EmberStatus zclColorControlMovetosat(uint16_t node,
												uint8_t ep,
												uint8_t saturation,
												uint16_t trsTime,
												bool options,
												uint8_t mask,
												uint8_t Override) {
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_MOVE_TO_SATURATION_COMMAND_ID);
	zclBufferAddByte(saturation);
	zclBufferAddWord(trsTime); 
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}

	emberAfCorePrintln("saturation=%d,trsTime=%d,options mask=%d,options override=%d\r\n",
					saturation,trsTime,mask,Override);
	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Move to Saturation]status=0x%02X\n",status);
	return status;
}
EmberStatus zclColorControlMovesat(uint16_t node,
												uint8_t ep,
												uint8_t mode,
												uint8_t rate,
												bool options,
												uint8_t mask,
												uint8_t Override) {
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_MOVE_SATURATION_COMMAND_ID);
	zclBufferAddByte(mode);
	zclBufferAddByte(rate);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}
	
	emberAfCorePrintln("move mode=0x%02x,rate=0x%02x,mask=0x%02x,Override=0x%02x\r\n",
					mode,rate,mask,Override);
	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Move Saturation]status=0x%02X\n",status);
	return status;
}
EmberStatus zclColorControlStepsat(uint16_t node,
											uint8_t ep,
											uint8_t mode,
											uint8_t size,
											uint8_t trsTime,
											bool options,
											uint8_t mask,
											uint8_t Override) {
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
							ZCL_STEP_SATURATION_COMMAND_ID);
	zclBufferAddByte(mode);
	zclBufferAddByte(size);
	zclBufferAddByte(trsTime);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}

	emberAfCorePrintln("step mode=%d,step size=%d,transition time=%d,mask=%d,override=%d\r\n",
					mode,size,trsTime,mask,Override);
	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Move Saturation]status=0x%02X\n",status);
	return status;
}
EmberStatus zclColorControlMovetohueandsat(uint16_t node,
														uint8_t ep,
														uint8_t hue,
														uint8_t saturation,
														uint16_t trsTime,
														bool options,
														uint8_t mask,
														uint8_t Override) {
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
							ZCL_MOVE_TO_HUE_AND_SATURATION_COMMAND_ID);

	zclBufferAddByte(hue);
	zclBufferAddByte(saturation);
	zclBufferAddWord(trsTime);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}
	
	emberAfCorePrintln("hue=%d,saturation=%d,trsTime=%d,mask=%d,Override=%d\r\n",
					hue,saturation,trsTime,mask,Override);
	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Move to hue and Saturation]status=0x%02X\n",status);
	return status;
}
EmberStatus zclColorControlMovetocolor(uint16_t node,
													uint8_t ep,
													uint16_t colorX,
													uint16_t colorY,
													uint16_t trsTime,
													bool options,
													uint8_t mask,
													uint8_t Override) {
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_MOVE_TO_COLOR_COMMAND_ID);
	zclBufferAddWord(colorX);
	zclBufferAddWord(colorY);
	zclBufferAddWord(trsTime);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override); 
	}

	emberAfCorePrintln("color x=%d,color y=%d,transition time=%d,options mask=0x%02x,options override=0x%02x\r\n",
					colorX,colorY,trsTime,mask,Override);
	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Move to color]status=0x%02X\n",status);
	return status;
}
EmberStatus zclColorControlMovecolor(uint16_t node,
												uint8_t ep,
												uint16_t rateX,
												uint16_t rateY,
												bool options,
												uint8_t mask,
												uint8_t Override) 
{
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_MOVE_COLOR_COMMAND_ID);
	zclBufferAddWord(rateX);
	zclBufferAddWord(rateY);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}
	
	emberAfCorePrintln("rateX=%d,rateY=%d,mask=%d,override=%d\r\n",rateX,rateY,mask,Override);

	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Move color]status=0x%02X\n",status);
	return status;

}
EmberStatus zclColorControlStepcolor(uint16_t node,
												uint8_t ep,
												uint16_t stepX,
												uint16_t stepY,
												uint16_t trsTime,
												bool options,
												uint8_t mask,
												uint8_t Override) {
	EmberStatus status;

	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_STEP_COLOR_COMMAND_ID);
	
	zclBufferAddWord(stepX);
	zclBufferAddWord(stepY);
	zclBufferAddWord(trsTime);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}

	emberAfCorePrintln("step x=%d,step y=%d,transition time=%d,options mask=%d,options override=%d\r\n",
		stepX,stepY,trsTime,mask,Override);
	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Step color]status=0x%02X\n",status);
	return status;
}

EmberStatus zclColorControlMovetocolortemp(uint16_t node,
															uint8_t ep,
															uint16_t colorTemp,
															uint16_t trsTime,
															bool options,
															uint8_t mask,
															uint8_t Override) {
	EmberStatus status;

	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_MOVE_TO_COLOR_TEMPERATURE_COMMAND_ID);
	zclBufferAddWord(colorTemp);
	zclBufferAddWord(trsTime);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}
	
	emberAfCorePrintln("colorTemp=%d,trsTime=%d,mask=%d,Override=%d\r\n",
					colorTemp,trsTime,mask,Override);
	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Move to color temperature]status=0x%02X\n",status);
	return status;
}
EmberStatus zclColorControlEmovetohue(uint16_t node,
												uint8_t ep,
												uint16_t hue,
												uint8_t dir,
												uint16_t trsTime,
												bool options,
												uint8_t mask,
												uint8_t Override) {
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									 ZCL_ENHANCED_MOVE_TO_HUE_COMMAND_ID);
	zclBufferAddWord(hue);
	zclBufferAddByte(dir);
	zclBufferAddWord(trsTime);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}
	emberAfCorePrintln("hue=%d,dir=%d,trsTime=%d\r\n",hue,dir,trsTime);

	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Enhanced Move to hue]status=0x%02X\n",status);
	return status;
}
EmberStatus zclColorControlEmovehue( uint16_t node,
											uint8_t ep,
											uint8_t mode,
											uint16_t rate,
											bool options,
											uint8_t mask,
											uint8_t Override){
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup(ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_ENHANCED_MOVE_HUE_COMMAND_ID);
	zclBufferAddByte(mode);
	zclBufferAddWord(rate);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}
	emberAfCorePrintln("mode=%d,rate=%d\r\n",mode,rate);
	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Enhanced Move hue]status=0x%02X\n",status);
	return status;
}

EmberStatus zclColorControlEstephue(uint16_t node,
												uint8_t ep,
												uint8_t mode,
												uint16_t size,
												uint16_t trsTime,
												bool options,
												uint8_t mask,
												uint8_t Override) {
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_ENHANCED_STEP_HUE_COMMAND_ID);	
	zclBufferAddByte(mode);
	zclBufferAddWord(size);
	zclBufferAddWord(trsTime);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}
	emberAfCorePrintln("mode=%d,size=%d,trsTime=%d\r\n",mode,size,trsTime);

	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Enhanced step hue]status=0x%02X\n",status);
	return status;
}

EmberStatus zclColorControlEmovetohueandsat(uint16_t node,
												uint8_t ep,
												uint16_t hue,
												uint8_t saturation,
												uint16_t trsTime,
												bool options,
												uint8_t mask,
												uint8_t Override) {
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_ENHANCED_MOVE_TO_HUE_AND_SATURATION_COMMAND_ID);
	zclBufferAddWord(hue);
	zclBufferAddByte(saturation);
	zclBufferAddWord(trsTime);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}
	emberAfCorePrintln("hue=%d,saturation=%d,trsTime=%d\r\n",hue,saturation,trsTime);

	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Enhanced move hue and sauturation]status=0x%02X\n",status);
	return status;
}
EmberStatus zclColorControlLoopSet(uint16_t node,
											uint8_t ep,
											uint8_t flags,
											uint8_t action,
											uint8_t dir,
											uint16_t time,
											uint16_t sHue,
											bool options,
											uint8_t mask,
											uint8_t Override) {
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_COLOR_LOOP_SET_COMMAND_ID);
	zclBufferAddByte(flags);
	zclBufferAddByte(action);
	zclBufferAddByte(dir);
	zclBufferAddWord(time);
	zclBufferAddWord(sHue);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}
	emberAfCorePrintln("update flags=%d,action=%d,direction=%d,time=%d,start hue=%d\r\n",
						flags,action,dir,time,sHue);
	status = rpcSendCommand(node,1,ep,false);

	emberAfCorePrintln("[Color loop set]status=0x%02X\n",status);
	return status;
}
EmberStatus zclColorControlStopmovestep(uint16_t node,
													uint8_t ep,
													bool options,
													uint8_t mask,
													uint8_t Override) {
	EmberStatus status;

	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_STOP_MOVE_STEP_COMMAND_ID);

	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}
	emberAfCorePrintln("options mask=%d,options override=%d\r\n",mask,Override);

	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Stop Move step]status=0x%02X\n",status);
	return status;

}
EmberStatus zclColorControlMovecolortemp(uint16_t node,
														uint8_t ep,
														uint8_t mode,
														uint16_t rate,
														uint16_t Tmin,
														uint16_t Tmax,
														bool options,
														uint8_t mask,
														uint8_t Override)
{
	EmberStatus status;

	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_MOVE_COLOR_TEMPERATURE_COMMAND_ID);
	zclBufferAddByte(mode);
	zclBufferAddWord(rate);
	zclBufferAddWord(Tmin);
	zclBufferAddWord(Tmax);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}
	emberAfCorePrintln("mode=%d,rate=%d,Tmin=%d,Tmax=%d,mask=%d,Override=%d\r\n",
						mode,rate,Tmin,Tmax,mask,Override);

	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Move color temperature]status=0x%02X\n",status);
	return status;
}
EmberStatus zclColorControlStepcolortemp(uint16_t node,
														uint8_t ep,
														uint8_t mode,
														uint16_t size,
														uint16_t trsTime,
														uint16_t minimum,
														uint16_t maximum,
														bool options,
														uint8_t mask,
														uint8_t Override) {
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_STEP_COLOR_TEMPERATURE_COMMAND_ID);
	zclBufferAddByte(mode);
	zclBufferAddWord(size);
	zclBufferAddWord(trsTime);
	zclBufferAddWord(minimum);
	zclBufferAddWord(maximum);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}
	emberAfCorePrintln("step mode=%d,step size=%d,transition time=%d,minimum=%d,maximum=%d,mask=%d,override=%d\r\n",
						mode,size,trsTime,minimum,maximum,mask,Override);

	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Step color temperature]status=0x%02X\n",status);
	return status;
}



EmberStatus zclGroupsAddGroup(uint16_t node,
									uint8_t ep,
									uint16_t id,
									char *name) {
	uint8_t i,len;
	EmberStatus status;
	
	if(name==NULL) return EMBER_INVALID_CALL;
		
	len = strlen(name);

	zcl_clu_client_cmd_buffer_setup( ZCL_GROUPS_CLUSTER_ID,
									ZCL_ADD_GROUP_COMMAND_ID);
	zclBufferAddWord(id);
	for(i=0;i<len;i++){
		zclBufferAddByte(name[i]);
	}
	
	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Add Group] id:%d,Name:%s,status:0x%02x\r\n",id,name,status);
	return status;
}

EmberStatus zclGroupsViewGroup(uint16_t node,
									uint8_t ep,
									uint16_t id) {
	EmberStatus status;
	
	zcl_clu_client_cmd_buffer_setup( ZCL_GROUPS_CLUSTER_ID,
									ZCL_VIEW_GROUP_COMMAND_ID);
	zclBufferAddWord(id);
	
	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[View Group] id:%d,status:0x%02x\r\n",id,status);

	return status;
}
									
EmberStatus zclGroupsGetGroupMembership(uint16_t node,
									uint8_t ep,
									uint16_t count,
									uint16_t *list) {
	uint8_t i;
	EmberStatus status;

	if(count==0||list==NULL) return EMBER_INVALID_CALL;
	
	zcl_clu_client_cmd_buffer_setup( ZCL_GROUPS_CLUSTER_ID,
									ZCL_GET_GROUP_MEMBERSHIP_COMMAND_ID);
	zclBufferAddWord(count);
	for(i=0;i<count;i++){
		zclBufferAddWord(list[i]);
	}
	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Get Group Membership] count:%d,status:0x%02x\r\n",count,status);

	return status;
}
									
EmberStatus zclGroupsRemoveGroup(uint16_t node,
									uint8_t ep,
									uint16_t id) {
	EmberStatus status;
	
	zcl_clu_client_cmd_buffer_setup( ZCL_GROUPS_CLUSTER_ID,
									ZCL_REMOVE_GROUP_COMMAND_ID);
	zclBufferAddWord(id);
	
	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Remove Group] id:%d,status:0x%02x\r\n",id,status);

	return status;
}

EmberStatus zclGroupsRemoveAllGroups(uint16_t node,
									uint8_t ep) {
	EmberStatus status;
	
	zcl_clu_client_cmd_buffer_setup( ZCL_GROUPS_CLUSTER_ID,
									ZCL_REMOVE_ALL_GROUPS_COMMAND_ID);
	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Remove All Groups]status:0x%02x\r\n",status);

	return status;
}

EmberStatus zclGroupsAddGroupIfIdentifying(uint16_t node,
									uint8_t ep,
									uint16_t id,
									char *name) {
	uint8_t i,len;
	EmberStatus status;
	
	if(name==NULL) return EMBER_INVALID_CALL;
		
	len = strlen(name);

	zcl_clu_client_cmd_buffer_setup( ZCL_GROUPS_CLUSTER_ID,
									ZCL_ADD_GROUP_IF_IDENTIFYING_COMMAND_ID);
	zclBufferAddWord(id);
	for(i=0;i<len;i++){
		zclBufferAddByte(name[i]);
	}
	
	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Add Group if Identifying] id:%d,Name:%s,status:0x%02x\r\n",id,name,status);
	return status;
}




EmberStatus zclScenesAddScene(uint16_t node,
									uint8_t ep,
									uint16_t g_id,
									uint16_t s_id,
									uint16_t trs_time,
									char *name,
									uint8_t extLen,
									uint8_t* extData) {
	uint8_t i,len;
	EmberStatus status;

	zcl_clu_client_cmd_buffer_setup( ZCL_SCENES_CLUSTER_ID,
									ZCL_ADD_SCENE_COMMAND_ID);
	zclBufferAddWord(g_id);
	zclBufferAddWord(s_id);
	zclBufferAddWord(trs_time);
	if(name!=NULL){
		len = strlen(name);
		for(i=0;i<len;i++){
			zclBufferAddByte(name[i]);
		}
		for(i=0;i<extLen;i++){
			zclBufferAddByte(extData[i]);
		}
	}
	
	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Add Scene] g_id:%d,s_id:%d,status:0x%02x\r\n",g_id,s_id,status);
	return status;
}

EmberStatus zclScenesViewScene(uint16_t node,
									uint8_t ep,
									uint16_t g_id,
									uint16_t s_id)
{
	uint8_t i,len;
	EmberStatus status;

	zcl_clu_client_cmd_buffer_setup( ZCL_SCENES_CLUSTER_ID,
									ZCL_VIEW_SCENE_COMMAND_ID);
	zclBufferAddWord(g_id);
	zclBufferAddWord(s_id);

	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[View Scene] g_id:%d,s_id:%d,status:0x%02x\r\n",g_id,s_id,status);
	return status;
}
EmberStatus zclScenesRemoveScene(uint16_t node,
								uint8_t ep,
								uint16_t g_id,
								uint16_t s_id)
{
	uint8_t i,len;
	EmberStatus status;

	zcl_clu_client_cmd_buffer_setup( ZCL_SCENES_CLUSTER_ID,
									ZCL_REMOVE_SCENE_COMMAND_ID);
	zclBufferAddWord(g_id);
	zclBufferAddWord(s_id);

	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Remove Scene] g_id:%d,s_id:%d,status:0x%02x\r\n",g_id,s_id,status);
	return status;
}
								
EmberStatus zclScenesRemoveAllScene(uint16_t node,
								uint8_t ep,
								uint16_t g_id)
{
	uint8_t i,len;
	EmberStatus status;

	zcl_clu_client_cmd_buffer_setup( ZCL_SCENES_CLUSTER_ID,
									ZCL_REMOVE_ALL_SCENES_COMMAND_ID);
	zclBufferAddWord(g_id);

	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Remove All Scene] g_id:%d,status:0x%02x\r\n",g_id,status);
	return status;
}
								
EmberStatus zclScenesStoreScene(uint16_t node,
									uint8_t ep,
									uint16_t g_id,
									uint16_t s_id)
{
	uint8_t i,len;
	EmberStatus status;

	zcl_clu_client_cmd_buffer_setup( ZCL_SCENES_CLUSTER_ID,
									ZCL_STORE_SCENE_COMMAND_ID);
	zclBufferAddWord(g_id);
	zclBufferAddWord(s_id);

	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Store Scene] g_id:%d,s_id:%d,status:0x%02x\r\n",g_id,s_id,status);
	return status;
}

EmberStatus zclScenesRecallScene(uint16_t node,
										uint8_t ep,
										uint16_t g_id,
										uint16_t s_id,
										uint16_t trsTime)
{
	uint8_t i,len;
	EmberStatus status;

	zcl_clu_client_cmd_buffer_setup( ZCL_SCENES_CLUSTER_ID,
									ZCL_RECALL_SCENE_COMMAND_ID);
	zclBufferAddWord(g_id);
	zclBufferAddWord(s_id);
	zclBufferAddWord(trsTime);

	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Recall Scene] g_id:%d,s_id:%d,trsTime:%d,status:0x%02x\r\n",g_id,s_id,trsTime,status);
	return status;
}
						
EmberStatus zclScenesGetSceneMembership(uint16_t node,
										uint8_t ep,
										uint16_t g_id)
{
	uint8_t i,len;
	EmberStatus status;

	zcl_clu_client_cmd_buffer_setup( ZCL_SCENES_CLUSTER_ID,
									ZCL_GET_SCENE_MEMBERSHIP_COMMAND_ID);
	zclBufferAddWord(g_id);


	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[View Scene] g_id:%d,status:0x%02x\r\n",g_id,status);
	return status;
}

EmberStatus zclScenesEnhancedAddScene(uint16_t node,
									uint8_t ep,
									uint16_t g_id,
									uint16_t s_id,
									uint16_t trs_time,
									char *name,
									uint8_t extLen,
									uint8_t* extData) {
	uint8_t i,len;
	EmberStatus status;

	zcl_clu_client_cmd_buffer_setup( ZCL_SCENES_CLUSTER_ID,
									ZCL_ENHANCED_ADD_SCENE_COMMAND_ID);
	zclBufferAddWord(g_id);
	zclBufferAddWord(s_id);
	zclBufferAddWord(trs_time);
	if(name!=NULL){
		len = strlen(name);
		for(i=0;i<len;i++){
			zclBufferAddByte(name[i]);
		}
		for(i=0;i<extLen;i++){
			zclBufferAddByte(extData[i]);
		}
	}
	
	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Enhanced Add Scene] g_id:%d,s_id:%d,status:0x%02x\r\n",g_id,s_id,status);
	return status;
}

EmberStatus zclScenesEnhancedViewScene(uint16_t node,
									uint8_t ep,
									uint16_t g_id,
									uint16_t s_id)
{
	uint8_t i,len;
	EmberStatus status;

	zcl_clu_client_cmd_buffer_setup( ZCL_SCENES_CLUSTER_ID,
									ZCL_ENHANCED_VIEW_SCENE_COMMAND_ID);
	zclBufferAddWord(g_id);
	zclBufferAddWord(s_id);

	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Enhanced View Scene] g_id:%d,s_id:%d,status:0x%02x\r\n",g_id,s_id,status);
	return status;
}

EmberStatus zclScenesCopyScene(uint16_t node,
									uint8_t ep,
									uint8_t mode,
									uint16_t gidFrom,
									uint16_t sidFrom,
									uint16_t gidTo,
									uint16_t sidTo)
{
	uint8_t i,len;
	EmberStatus status;

	zcl_clu_client_cmd_buffer_setup( ZCL_SCENES_CLUSTER_ID,
									ZCL_COPY_SCENE_COMMAND_ID);

	zclBufferAddByte(mode);
	zclBufferAddWord(gidFrom);
	zclBufferAddWord(sidFrom);
	zclBufferAddWord(gidTo);
	zclBufferAddWord(sidTo);

	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Copy Scene] mode:%d,gidFrom:%d,sidFrom:%d,gidTo:%d,sidTo:%d,status:0x%02x\r\n",mode,gidFrom,sidFrom,gidTo,sidTo,status);
	return status;
}


									


EmberStatus zclLevel_MoveToLevel(uint16_t node,
										uint8_t ep,
										uint8_t level,
										uint16_t trsTime,
										uint8_t *mask,
										uint8_t *override)
{
	uint8_t i,len;
	EmberStatus status;

	zcl_clu_client_cmd_buffer_setup( ZCL_LEVEL_CONTROL_CLUSTER_ID,
									ZCL_MOVE_TO_LEVEL_COMMAND_ID);
	zclBufferAddByte(level);
	zclBufferAddWord(trsTime);
	if(mask!=NULL){
		zclBufferAddByte(mask);
		if(override!=NULL){
			zclBufferAddByte(override);
		}
	}

	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Move To Level] status:0x%02x\r\n",status);
	return status;
}

EmberStatus zclLevel_Move(uint16_t node,
								uint8_t ep,
								uint8_t mode,
								uint8_t rate,
								uint8_t *mask,
								uint8_t *override)
{
	uint8_t i,len;
	EmberStatus status;

	zcl_clu_client_cmd_buffer_setup( ZCL_LEVEL_CONTROL_CLUSTER_ID,
									ZCL_STEP_COMMAND_ID);
	zclBufferAddByte(mode);
	zclBufferAddByte(rate);
	if(mask!=NULL){
		zclBufferAddByte(mask);
		if(override!=NULL){
			zclBufferAddByte(override);
		}
	}

	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Move] status:0x%02x\r\n",status);
	return status;
}
EmberStatus zclLevel_Step(uint16_t node,
								uint8_t ep,
								uint8_t mode,
								uint8_t size,
								uint16_t trsTime,
								uint8_t *mask,
								uint8_t *override)
{
	uint8_t i,len;
	EmberStatus status;

	zcl_clu_client_cmd_buffer_setup( ZCL_LEVEL_CONTROL_CLUSTER_ID,
									ZCL_STEP_COMMAND_ID);
	zclBufferAddByte(mode);
	zclBufferAddByte(size);
	zclBufferAddWord(trsTime);
	if(mask!=NULL){
		zclBufferAddByte(mask);
		if(override!=NULL){
			zclBufferAddByte(override);
		}
	}

	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Move] step:0x%02x\r\n",status);
	return status;
}

EmberStatus zclLevel_Stop(uint16_t node,
								uint8_t ep,
								uint8_t *mask,
								uint8_t *override)
{
	uint8_t i,len;
	EmberStatus status;

	zcl_clu_client_cmd_buffer_setup( ZCL_LEVEL_CONTROL_CLUSTER_ID,
									ZCL_STOP_COMMAND_ID);

	if(mask!=NULL){
		zclBufferAddByte(mask);
		if(override!=NULL){
			zclBufferAddByte(override);
		}
	}

	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Move] step:0x%02x\r\n",status);
	return status;
}


EmberStatus zclLevel_MoveToLevelWithOnOff(uint16_t node,
										uint8_t ep,
										uint8_t level,
										uint16_t trsTime,
										uint8_t *mask,
										uint8_t *override)
{
	uint8_t i,len;
	EmberStatus status;

	zcl_clu_client_cmd_buffer_setup( ZCL_LEVEL_CONTROL_CLUSTER_ID,
									ZCL_MOVE_TO_LEVEL_WITH_ON_OFF_COMMAND_ID);
	zclBufferAddByte(level);
	zclBufferAddWord(trsTime);
	if(mask!=NULL){
		zclBufferAddByte(mask);
		if(override!=NULL){
			zclBufferAddByte(override);
		}
	}

	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Move To Level] status:0x%02x\r\n",status);
	return status;
}

EmberStatus zclLevel_MoveWithOnOff(uint16_t node,
								uint8_t ep,
								uint8_t mode,
								uint8_t rate,
								uint8_t *mask,
								uint8_t *override)
{
	uint8_t i,len;
	EmberStatus status;

	zcl_clu_client_cmd_buffer_setup( ZCL_LEVEL_CONTROL_CLUSTER_ID,
									ZCL_MOVE_WITH_ON_OFF_COMMAND_ID);
	zclBufferAddByte(mode);
	zclBufferAddByte(rate);
	if(mask!=NULL){
		zclBufferAddByte(mask);
		if(override!=NULL){
			zclBufferAddByte(override);
		}
	}

	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Move] status:0x%02x\r\n",status);
	return status;
}
EmberStatus zclLevel_StepWithOnOff(uint16_t node,
								uint8_t ep,
								uint8_t mode,
								uint8_t size,
								uint16_t trsTime,
								uint8_t *mask,
								uint8_t *override)
{
	uint8_t i,len;
	EmberStatus status;

	zcl_clu_client_cmd_buffer_setup( ZCL_LEVEL_CONTROL_CLUSTER_ID,
									ZCL_STEP_WITH_ON_OFF_COMMAND_ID);
	zclBufferAddByte(mode);
	zclBufferAddByte(size);
	zclBufferAddWord(trsTime);
	if(mask!=NULL){
		zclBufferAddByte(mask);
		if(override!=NULL){
			zclBufferAddByte(override);
		}
	}

	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Move] step:0x%02x\r\n",status);
	return status;
}

EmberStatus zclLevel_StopWithOnOff(uint16_t node,
								uint8_t ep,
								uint8_t *mask,
								uint8_t *override)
{
	uint8_t i,len;
	EmberStatus status;

	zcl_clu_client_cmd_buffer_setup( ZCL_LEVEL_CONTROL_CLUSTER_ID,
									ZCL_STOP_WITH_ON_OFF_COMMAND_ID);

	if(mask!=NULL){
		zclBufferAddByte(mask);
		if(override!=NULL){
			zclBufferAddByte(override);
		}
	}

	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Move] step:0x%02x\r\n",status);
	return status;
}








EmberStatus zclWD_StartWarning(uint16_t node,
								uint8_t ep,
								uint8_t mode,
								uint16_t duration,
								uint8_t cycle,
								uint8_t level)
{
	uint8_t i,len;
	EmberStatus status;

	zcl_clu_client_cmd_buffer_setup( ZCL_IAS_WD_CLUSTER_ID,
									ZCL_START_WARNING_COMMAND_ID);

	zclBufferAddByte(mode);
	zclBufferAddWord(duration);
	zclBufferAddByte(cycle);
	zclBufferAddByte(level);

	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Start Warning] status:0x%02x\r\n",status);
	return status;
}

EmberStatus zclWD_Squawk(uint16_t node,
								uint8_t ep,
								uint8_t mode)
{
	EmberStatus status;
	
	zcl_clu_client_cmd_buffer_setup( ZCL_IAS_WD_CLUSTER_ID,
									ZCL_SQUAWK_COMMAND_ID);
	
	zclBufferAddByte(mode);
	
	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Squawk] status:0x%02x\r\n",status);
	return status;
}

EmberStatus zclThermostat_Setpoint_Raise_Lower(uint16_t node,
								uint8_t ep,
								uint8_t mode,
								uint8_t amount)
{
	EmberStatus status;
	
	zcl_clu_client_cmd_buffer_setup( ZCL_THERMOSTAT_CLUSTER_ID,
									ZCL_SETPOINT_RAISE_LOWER_COMMAND_ID);
	
	zclBufferAddByte(mode);
	zclBufferAddByte(amount);
	
	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Setpoint Raise/Lower] status:0x%02x\r\n",status);
	return status;
}
/*
EmberStatus zclThermostat_Set_Weekly_Schedule(uint16_t node,
								uint8_t ep,
								uint8_t mode,
								uint8_t amount)
{
	EmberStatus status;
	
	zcl_clu_client_cmd_buffer_setup( ZCL_THERMOSTAT_CLUSTER_ID,
									ZCL_SET_WEEKLY_SCHEDULE_COMMAND_ID);
	
	zclBufferAddByte(mode);
	zclBufferAddByte(amount);
	
	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Setpoint Raise/Lower] status:0x%02x\r\n",status);
	return status;
}*/
EmberStatus zclThermostat_GetWeeklySchedule(uint16_t node,
								uint8_t ep,
								uint8_t days,
								uint8_t mode)
{
	EmberStatus status;
	
	zcl_clu_client_cmd_buffer_setup( ZCL_THERMOSTAT_CLUSTER_ID,
									ZCL_GET_WEEKLY_SCHEDULE_COMMAND_ID);
	
	zclBufferAddByte(days);
	zclBufferAddByte(mode);
	
	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Get Weekly Schedule] status:0x%02x\r\n",status);
	return status;
}
EmberStatus zclThermostat_ClearWeeklySchedule(uint16_t node,
								uint8_t ep)
{
	EmberStatus status;
	
	zcl_clu_client_cmd_buffer_setup( ZCL_THERMOSTAT_CLUSTER_ID,
									ZCL_CLEAR_WEEKLY_SCHEDULE_COMMAND_ID);
	
	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Clear Weekly Schedule] status:0x%02x\r\n",status);
	return status;
}
								
EmberStatus zclThermostat_GetRelayStatusLog(uint16_t node,
														uint8_t ep)
{
	EmberStatus status;
	
	zcl_clu_client_cmd_buffer_setup( ZCL_THERMOSTAT_CLUSTER_ID,
									ZCL_GET_RELAY_STATUS_LOG_COMMAND_ID);
	
	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Get Relay Status Log] status:0x%02x\r\n",status);
	return status;
}



