#include "kk_tsl_property_report.h"


const char *kk_tsl_rpt_status_string[] = {
	"Success",
	"Error",
	"Invaild Value",
	"Invaild Len",
	"Invaild Type"
};
static cJSON* kk_check_identify(const char * identify,cJSON* root,int index,int status)
{
	int rev = 0,startIdx2 = 0,startIdx1 = 0;
	char *Identify_str;
	char tmp_Identity[64] = {0};	

	rev = kk_tsl_utils_memtok(identify,'.',2,&startIdx2);
	if(!rev){
		cJSON* str = NULL;
		cJSON* str_r = NULL;
		kk_tsl_utils_memtok(identify,'.',1,&startIdx1);
		str = rpc_cJSON_CreateObject();
		Identify_str = identify + 1 + startIdx2;
		memset(tmp_Identity,0x0,sizeof(tmp_Identity));
		memcpy(tmp_Identity,identify+startIdx1+1,startIdx2-startIdx1);
		rpc_cJSON_AddNumberToObject(str, Identify_str,status);
		str_r = rpc_cJSON_CreateObject();
		rpc_cJSON_AddItemToObject(str_r,tmp_Identity,str);
		memset(tmp_Identity,0x0,sizeof(tmp_Identity));
		memcpy(tmp_Identity,identify,startIdx1);		
		rpc_cJSON_AddItemToObject(root,tmp_Identity,str_r);
		return root;
	}
	else{
		rev = kk_tsl_utils_memtok(identify,'.',1,&startIdx1);
		if(!rev){
			cJSON* str = NULL;
			str = rpc_cJSON_CreateObject();
			Identify_str = identify + 1 + startIdx1;
			memset(tmp_Identity,0x0,sizeof(tmp_Identity));
			memcpy(tmp_Identity,identify,startIdx1);
			rpc_cJSON_AddNumberToObject(str, Identify_str,status);
			rpc_cJSON_AddItemToObject(root,tmp_Identity,str);
			return root;
		}		

	}
	return NULL;


}
static int kk_tsl_report(EmberEUI64 mac,uint8_t EP,int status,uint16_t clusterId,uint16_t attributeId)
{
	cJSON* root,*root_tmp;
	int index;
	char *Identify;
	sub_dev_node_t *node = NULL;
	kk_device_table_s *dev;
	char macString[RPC_EUI64_STRING_LENGTH];

	rpc_eui64ToString(mac,macString);

	root = rpc_cJSON_CreateObject();
	index = kk_get_tsl_index(EP,clusterId,attributeId);
	if(index < 0){
		dev = kk_device_find_by_mac(mac);
		if(dev!=NULL){
			index = kk_get_tsl_glb_index(dev->productCode,EP,clusterId,attributeId);
		}
		
		if(index < 0){
			return tsl_rpt_err;
		}else{
			root_tmp = kk_check_identify(g_tsl_zigbee_map_glb[index].map.Identity,root,index,status);
			if(root_tmp != NULL){
				kk_rpc_report_status(root_tmp,mac);
				return tsl_rpt_success;
			}
			else{
				Identify = g_tsl_zigbee_map_glb[index].map.Identity;
			}
		}
	}else{
			root_tmp = kk_check_identify(g_tsl_zigbee_map[index].Identity,root,index,status);
			if(root_tmp != NULL){
				kk_rpc_report_status(root_tmp,mac);
				return tsl_rpt_success;
			}
			else{
				Identify = g_tsl_zigbee_map[index].Identity;
			}
	}
	rpc_cJSON_AddNumberToObject(root, Identify,status);
	kk_rpc_report_status(root,mac);
	return tsl_rpt_success;
}



void kk_tsl_report_attribute(EmberEUI64 eui64,
									uint8_t EP,
									EmberAfClusterId clusterId,
									EmberAfAttributeId attributeId,
									uint8_t dataType,
									uint8_t len,
									uint8_t *data)
{
	int i,j,num,status;
	char macString[19] = {0};	
	sub_dev_node_t *node = NULL;
	int res = 0;

	UTIL_LOG_INFO("\n********************kk tsl report attribute********************\n");
	emberAfDebugPrint("mac:");
	emberAfDebugPrintln(",ep:%d,clu:0x%04X,attr:0x%04X,dataType=0x%02x,len=%d,data:",
						EP,clusterId,attributeId,dataType,len);
	emberAfDebugPrintBuffer(data,len,true);

	num = kk_get_tsl_num();
	for(i=0;i<num;i++){
		if( g_tsl_zigbee_map[i].clusterId == clusterId &&
			g_tsl_zigbee_map[i].attributeId == attributeId &&
			g_tsl_zigbee_map[i].zigbee_report!=NULL){
			status = g_tsl_zigbee_map[i].zigbee_report(eui64,EP,clusterId,attributeId,dataType,len,data);
			emberAfDebugPrintln("report status:%d",status);
			return ;
		}
	}
	rpc_eui64ToString(eui64,macString);
	res = kk_sub_tsl_get_device_by_mac(macString,&node);
	if(res != tsl_rpt_success){
		emberAfAppPrintln("[kk_tsl_report_attribute] error~~~~~~~~~\n");
		return;
	}
	
	num = kk_get_tsl_glb_num();
	for(i=0;i<num;i++){
		if( g_tsl_zigbee_map_glb[i].map.clusterId == clusterId &&
			g_tsl_zigbee_map_glb[i].map.attributeId == attributeId &&
			strncmp(node->productCode,g_tsl_zigbee_map_glb[i].ProductCode,strlen(node->productCode)) == 0 &&
			g_tsl_zigbee_map_glb[i].map.zigbee_report!=NULL){
			status = g_tsl_zigbee_map_glb[i].map.zigbee_report(eui64,EP,clusterId,attributeId,dataType,len,data);
			emberAfDebugPrintln("--report status:%s",kk_tsl_rpt_status_string[status]);
			return ;
		}
	}	
}

int kk_tsl_report_global_Brightness(EmberEUI64 eui64,uint8_t EP,EmberAfClusterId clusterId,EmberAfAttributeId attributeId,uint8_t dataType,uint8_t len,uint8_t *data)
{
	uint8_t value = data[0];
	emberAfAppPrintln("[tsl report:kk_tsl_report_global_Brightness] value:%d\n",value);
	printf("[%s][%d]dataType:%d\n",__FUNCTION__,__LINE__,dataType);
	if(dataType == ZCL_INT8U_ATTRIBUTE_TYPE){
		printf("[%s][%d]len:%d\n",__FUNCTION__,__LINE__,len);
		if(len==1){
			printf("[%s][%d]\n",__FUNCTION__,__LINE__);
			kk_tsl_report(eui64,EP,value,clusterId,attributeId);
			return tsl_rpt_success;
		}
		return tsl_rpt_invaild_len;
	}
	return tsl_rpt_invaild_type;
}
int kk_tsl_report_global_RGB(EmberEUI64 eui64,uint8_t EP,EmberAfClusterId clusterId,EmberAfAttributeId attributeId,uint8_t dataType,uint8_t len,uint8_t *data)
{
	uint8_t value = data[0];
	emberAfAppPrintln("[tsl report:kk_tsl_report_global_RGB] value:%d\n",value);
	printf("[%s][%d]dataType:%d\n",__FUNCTION__,__LINE__,dataType);
	if(dataType == ZCL_INT8U_ATTRIBUTE_TYPE){
		printf("[%s][%d]len:%d\n",__FUNCTION__,__LINE__,len);
		if(len==1){
			printf("[%s][%d]\n",__FUNCTION__,__LINE__);
			kk_tsl_report(eui64,EP,value,clusterId,attributeId);
			return tsl_rpt_success;
		}
		return tsl_rpt_invaild_len;
	}
	return tsl_rpt_invaild_type;
}

int kk_tsl_report_global_onoff(EmberEUI64 eui64,uint8_t EP,EmberAfClusterId clusterId,EmberAfAttributeId attributeId,uint8_t dataType,uint8_t len,uint8_t *data)
{
	uint8_t OnOff;
	emberAfAppPrintln("[tsl report:Gloabl] OnOff~~~~~~~~~");
	if(dataType == ZCL_BOOLEAN_ATTRIBUTE_TYPE){
		if(len==1){
			OnOff = data[0];
			if(OnOff==0 || OnOff==1){
				kk_tsl_report(eui64,EP,OnOff,clusterId,attributeId);
				return tsl_rpt_success;
			}
			return tsl_rpt_invaild_val;
		}
		return tsl_rpt_invaild_len;
	}
	return tsl_rpt_invaild_type;
}

int kk_tsl_report_windowCovering_mode(EmberEUI64 eui64,uint8_t EP,EmberAfClusterId clusterId,EmberAfAttributeId attributeId,uint8_t dataType,uint8_t len,uint8_t *data)
{
	uint8_t mode;
	emberAfAppPrintln("[tsl report:Window Covering] Mode~~~~~~~~~");

	if(dataType == ZCL_BITMAP8_ATTRIBUTE_TYPE){
		if(len==1){
			if(data[0]&BIT(1)){
				mode = WC_calibration_mode;
			}else if(data[0]&BIT(0)){
				mode = WC_reversed_dir;
			}else{
				mode = WC_normal_dir;
			}

			kk_tsl_report(eui64,EP,mode,clusterId,attributeId);
			return tsl_rpt_success;
		}
		return tsl_rpt_invaild_len;
	}
	return tsl_rpt_invaild_type;
}
int kk_tsl_report_windowCovering_position(EmberEUI64 eui64,uint8_t EP,EmberAfClusterId clusterId,EmberAfAttributeId attributeId,uint8_t dataType,uint8_t len,uint8_t *data)
{
	uint8_t position;
	emberAfAppPrintln("[tsl report:Window Covering] Position~~~~~~~~~");

	if(dataType == ZCL_INT8U_ATTRIBUTE_TYPE){
		if(len==1){
			position = data[0];
			kk_tsl_report(eui64,EP,position,clusterId,attributeId);
			return tsl_rpt_success;
		}
		return tsl_rpt_invaild_len;
	}
	return tsl_rpt_invaild_type;
}

















