#ifndef __KK_SCENE_H__
#define __KK_SCENE_H__

#include "kk_tsl_common.h"
#include "sqlite3.h"
#include "kk_log.h"
#include "kk_scene_db.h"
#include "cJSON.h"
#include "kk_tsl_api.h"
#include "kk_dm_mng.h"
typedef struct kk_scene_action_detail{
    char deviceCode[DEVICE_CODE_MAXLEN];
	char propertyName[DEVICE_PROPERTY_NAME_MAX];
	char propertyValue[DEVICE_PROPERTY_VALUE_MAX];
	int epNum;
	int delay;
} kk_scene_action_detail_t;

typedef struct kk_scene_action_info_ex{
	kk_scene_action_detail_t info;
	struct kk_scene_action_info_ex * next;
} kk_scene_action_info_ex_t;

typedef struct kk_scene_action{
    char gwdeviceCode[DEVICE_CODE_MAXLEN];
	char sceneId[16];
	kk_scene_action_info_ex_t *actionInfo;
	struct kk_scene_action * next;
} kk_scene_action_t;


typedef struct {	
	char productCode[PRODUCT_CODE_MAXLEN];
	char deviceCode[DEVICE_CODE_MAXLEN];
	char fatherdeviceCode[DEVICE_CODE_MAXLEN];	
	char propertyName[32];
	char propertyValue[32];
} kk_scene_action_info_t;

typedef struct kk_action_list{	
	time_t starttime;
	kk_scene_action_info_t *action;
	struct kk_action_list *next;
} kk_scene_action_delay_t;

typedef struct kk_embedscene_list{	
	time_t starttime;	
	char  executeSceneId[32];
	struct kk_embedscene_list *next;
} kk_scene_embed_delay_t;


typedef struct kk_scene_timer_list{	
	time_t starttime;
	char sceneId[32];
	int repeatday;
	struct kk_scene_timer_list *next;
} kk_scene_timer_list_t;
typedef struct {
	void *mutex;
	sqlite3 *pDb;
	void *s_scene_thread;
} kk_scene_ctx_t;


int kk_scene_init(void);
int kk_scene_iftt_check(const char*deviceCode,cJSON *param);
int kk_scene_execute_scene(const char *sceneId,const char *msgId);
void kk_scene_execute_event_post(const char* sceneId,const char *msgId);
int kk_scene_query_trigger_info(const char *deviceCode,cJSON *param);
int kk_scene_execute_action(const char* sceneId,char *msgId);
int kk_scene_check_condition(const char *sceneId);
int kk_scene_check_trigger_condition(const char *sceneId);
int kk_scene_get_scene_info(const char* sceneId,int *sceneType,int *enable);
void kk_scene_remove_timer_info(char *sceneId,int lockflag);
kk_scene_ctx_t *_kk_scene_get_ctx(void);
void _kk_scene_lock(void);
void _kk_scene_unlock(void);
int kk_scene_parse_addscene(const cJSON* args,char *sceneId,int isUpdate,const char *msgId);
kk_tsl_t * kk_scene_shadow(void);
int kk_scene_parse_updatescene(const cJSON* arg,char *sceneId);
int kk_scene_parse_deletescene(char *sceneId);
 int kk_scene_delete_send_to_gw(const char *sceneId);
int kk_scene_parse_scene_action(const cJSON* str,const char *sceneId,int isUpdate);
int kk_scene_execute_quickpanel(const char *buttonId,char *deviceCode);
int kk_scene_action_add(const char *gwdeviceCode,const char *sceneId,kk_scene_action_detail_t detail);
int BodySensorTrigger_check(void);
int bodySensor_find(const char *deviceCode,int ep);
int is_BodySensor_dev(const char *productCode);

#endif

