#ifndef _KK_SUBDEV_DB_H_
#define _KK_SUBDEV_DB_H_
#include "kk_tsl_common.h"

typedef struct {
	char deviceCode[DEVICE_CODE_MAXLEN];
	int SensorType;
} SensorType_t;
typedef struct {
	char deviceCode[DEVICE_CODE_MAXLEN];
} DeviceCode_t;
typedef struct {
	char ip[17];
	char name[128];
	char serialId[128];
	char roomid[32];
	char version[32];
	char mac[32];
	int type;
} ScreenDevInfo_t;
int kk_subDb_init(void);
int kk_subDev_insert_db(int devType,char productCode[PRODUCT_CODE_MAXLEN], \
										char deviceCode[DEVICE_CODE_MAXLEN],char fatherMac[DEVICE_MAC_MAXLEN],char mac[DEVICE_MAC_MAXLEN], char version[DEVICE_VERSION_MAXLEN],int heartbeat);

int kk_subDev_delete_byMac(char device_mac[DEVICE_MAC_MAXLEN]);
int kk_subDev_update_auth(int isAuth,const char *deviceCode);
int kk_subDev_update_sceneSupport(int sceneSupport,const char *deviceCode);
int kk_subDev_delete_by_dcode(char deviceCode[DEVICE_CODE_MAXLEN]);
int kk_subDev_update_productType(char *productType,const char *deviceCode);
int kk_subDev_send_property_get_from_db(void);
int kk_subDev_send_property_get(const char *fatherDeviceCode);

int kk_subDev_check_scene_support(const char *deviceCode);
int kk_subDev_set_action_by_productType(const char *productType,const char *roomId,const char *sceneId,const char *propertyName,const char *propertyValue,const char *type,int delay);
int kk_subDev_update_offline(int isOffline,const char *deviceCode);
int kk_subDev_getSensors_reply(SensorType_t*list);
int kk_load_subDevice(void);
int kk_subDev_check_auth(int devType);
int kk_screenDev_insert_db(int devType,char *serialId, \
										char *ip,char *mac,char *version,char *expand);
int kk_screenDev_update_room(char *serialId,char *roomid,char *roomname,char* name);
int kk_screenDev_delete_by_serialId(char *serialId);
int kk_get_screenDev_list(ScreenDevInfo_t*list);
int kk_get_screenDev_info(ScreenDevInfo_t *devInfo,char*serialId);
int kk_subDev_getDeviceCodes_byProductType(DeviceCode_t *list,char *type);
enum{
	DB_SUB_IDX = 0,
	DB_SUB_ONLINE,
	DB_SUB_PRODUCTCODE,
	DB_SUB_DEVICECODE,
	DB_SUB_MAC,
	DB_SUB_FATHERDEVICECODE,
	DB_SUB_VERSION,
	DB_SUB_AUTH,
	DB_SUB_DEVTYPE,	
	DB_SUB_HEARTBEAT,	
	DB_SUB_PRODUCTTYPE,
	DB_SUB_SCENESUPPORT
};
enum{
	DB_SCREEN_IDX = 0,
	DB_SCREEN_ONLINE,
	DB_SCREEN_TYPE,
	DB_SCREEN_SERIALID,
	DB_SCREEN_IP,
	DB_SCREEN_NAME,
	DB_SCREEN_MAC,
	DB_SCREEN_VERSION,
	DB_SCREEN_ROOMID,
	DB_SCREEN_ROOMNAME,	
	DB_SCREEN_EXPAND,	
};
#endif
