
#ifndef __KK_PRODUCT_H__
#define __KK_PRODUCT_H__
#include <stdio.h>

#ifndef _IN_
    #define _IN_
#endif

#ifndef _OU_
    #define _OU_
#endif

#define PRODUCT_TYPE_LEN         (32+1)
#define PRODUCT_CODE_LEN         (32+1)
#define DEVICE_CODE_LEN          (32+1)
#define MAC_ADDR_LEN_MAX            (10)
#define PID_STRLEN_MAX              (64)
#define MID_STRLEN_MAX              (64)
#define IOTX_URI_MAX_LEN            (135)  /* IoTx CoAP/HTTP uri & MQTT topic maximal length */
#define PID_STR_MAXLEN              (64)
#define MID_STR_MAXLEN              (64)
#define PRODUCT_SECRET_MAXLEN       (64 + 1)
#define FIRMWARE_VERSION_MAXLEN     (32 + 1)
#define VERSION_MAXLEN     (16 + 1)
#define HAL_CID_LEN                 (64 + 1)
#define NETWORK_ADDR_LEN        (16+1)        /* IP�����ַ�ĳ��� */
#define MAC_ADDR_LEN        (17+1)
#define SN_ADDR_LEN        (32+1)

#define PRODUCT_TPYE  "kk"

#define KK_GW_PRODUCTID    "gateway_2"
#define KK_CCU_RANDOM    "0000000000"
#define KK_CCU_NAME      "NEW_CCU"
/*
#ifdef CONFIG_A133_PLATFORM
#define  KK_DEVICESECRET_PATH   "/data/local/kk/kk_deviceSecret.txt"
#define  KK_TOKEN_PATH   "/data/local/kk/kk_token.txt"
#define KK_DEVICE_MAP_FILE_PATH      "/data/local/kk/map/device_%s.json"
#define GET_CCUID_CMD               "cat /mnt/private/ULI/factory/ccuinfo.txt"//"getprop ro.ccuinfo"//
#define GET_KEY_CMD                 "cat /mnt/private/ULI/factory/ccuinfo.txt"
#define GET_PRODUCTID_CMD           "getprop ro.product.ccu.pid"
#define KK_DB_FILE                  "/data/local/kk/db/kk_database.db"
#define TSL_SUBDEVICE_PATH_FILE     "/data/local/kk/tsl/product_%s.json"
#define TSL_GATEWAY_PATH_FILE       "/data/local/kk/tsl/gateway_%s.json"
#define TSL_CCU_PATH_FILE           "/data/local/kk/tsl/ccu_%s.json"
#define TSL_SCENE_PATH_FILE         "/data/local/kk/tsl/ccu_%s_scene.json"
#define OTA_IMG_PATH                "/data/local/OTA/"
#define OTA_IMG_FILE                "/data/local/OTA/app_squashfs.img"
#define OTA_IMG_FILE_MD5            "/data/local/OTA/app_squashfs.img.md5"
#define  KK_CONFIG_FILE_PATH        "/data/local/kk/kk_cloud_conf.json"
#define  KK_DEFAULT_CONFIG_FILE_PATH    "/data/local/kk/etc/cloud_default_config.json"
#define  KK_AUTH_CONFIG_FILE_PATH    "/data/local/kk/auth_conf.json"
#elif CONFIG_8197_PLATFORM
#define  KK_DEVICESECRET_PATH       "/data/kk/kk_deviceSecret.txt"
#define  KK_TOKEN_PATH              "/data/kk/kk_token.txt"
#define KK_DEVICE_MAP_FILE_PATH      "/data/kk/map/device_%s.json"
#define GET_CCUID_CMD               "eval `flash get CUSTOMER_HW_KK_OPTION0`; echo $CUSTOMER_HW_KK_OPTION0"
#define GET_KEY_CMD                 "eval `flash get CUSTOMER_HW_KK_OPTION1`; echo $CUSTOMER_HW_KK_OPTION1"
#define GET_PRODUCTID_CMD           "eval `flash get CUSTOMER_HW_KK_OPTION2`; echo $CUSTOMER_HW_KK_OPTION2"
#define KK_DB_FILE                  "/data/kk/kk_database.db"
#define TSL_SUBDEVICE_PATH_FILE     "/data/kk/tsl/product_%s.json"
#define TSL_GATEWAY_PATH_FILE       "/data/kk/tsl/gateway_%s.json"
#define TSL_CCU_PATH_FILE           "/data/kk/tsl/ccu_%s.json"
#define TSL_SCENE_PATH_FILE         "/data/kk/tsl/ccu_%s_scene.json"
#define OTA_IMG_PATH                "/data/OTA/"
#define OTA_IMG_FILE                "/data/OTA/app_squashfs.img"
#define OTA_IMG_FILE_MD5            "/data/OTA/app_squashfs.img.md5"
#define  KK_CONFIG_FILE_PATH        "/data/kk/kk_cloud_conf.json"
#define  KK_DEFAULT_CONFIG_FILE_PATH    "/app/ccuApps/config/cloud_default_config.json"
#define  KK_AUTH_CONFIG_FILE_PATH    "/tmp/auth_conf.json"

#else
#define  KK_DEVICESECRET_PATH       "/data/kk/kk_deviceSecret.txt"
#define  KK_TOKEN_PATH              "/data/kk/kk_token.txt"
#define KK_DEVICE_MAP_FILE_PATH      "/data/kk/map/device_%s.json"
#define GET_CCUID_CMD               "fw_printenv uuid -n"
#define GET_KEY_CMD                 "fw_printenv key -n"
#define GET_PRODUCTID_CMD           "fw_printenv pid -n"
#define KK_DB_FILE                  "/data/kk/kk_database.db"
#define TSL_SUBDEVICE_PATH_FILE     "/data/kk/tsl/product_%s.json"
#define TSL_GATEWAY_PATH_FILE       "/data/kk/tsl/gateway_%s.json"
#define TSL_CCU_PATH_FILE           "/data/kk/tsl/ccu_%s.json"
#define TSL_SCENE_PATH_FILE         "/data/kk/tsl/ccu_%s_scene.json"
#define OTA_IMG_PATH                "/data/OTA/"
#define OTA_IMG_FILE                "/data/OTA/app_squashfs.img"
#define OTA_IMG_FILE_MD5            "/data/OTA/app_squashfs.img.md5"
#define  KK_CONFIG_FILE_PATH        "/data/kk/kk_cloud_conf.json"
#define  KK_DEFAULT_CONFIG_FILE_PATH    "/app/ccuApps/config/cloud_default_config.json"
#define  KK_AUTH_CONFIG_FILE_PATH    "/tmp/auth_conf.json"
#endif
*/

#ifdef CONFIG_A133_PLATFORM
#define STORSGE_DIR  "/data/local"
#define GET_CCUID_CMD               "getprop app.ccuinfo"//"cat /mnt/private/ULI/factory/ccuinfo.txt"//"getprop ro.ccuinfo"//
#define GET_KEY_CMD                 "getprop app.ccuinfo"//"cat /mnt/private/ULI/factory/ccuinfo.txt"
#define GET_PRODUCTID_CMD           "getprop ro.product.ccu.pid"
#elif CONFIG_8197_PLATFORM
#define STORSGE_DIR  "/data"
#define GET_CCUID_CMD               "eval `flash get CUSTOMER_HW_KK_OPTION0`; echo $CUSTOMER_HW_KK_OPTION0"
#define GET_KEY_CMD                 "eval `flash get CUSTOMER_HW_KK_OPTION1`; echo $CUSTOMER_HW_KK_OPTION1"
#define GET_PRODUCTID_CMD           "eval `flash get CUSTOMER_HW_KK_OPTION2`; echo $CUSTOMER_HW_KK_OPTION2"
#else
#define STORSGE_DIR  "/data"
#define GET_CCUID_CMD               "fw_printenv uuid -n"
#define GET_KEY_CMD                 "fw_printenv key -n"
#define GET_PRODUCTID_CMD           "fw_printenv pid -n"
#endif

#define KK_DEVICESECRET_PATH_SUB      	"kk/kk_deviceSecret.txt"
#define KK_TOKEN_PATH_SUB      			"kk/kk_token.txt"
#define KK_DEVICE_MAP_FILE_PATH_SUB     "kk/map/device_%s.json"
#ifdef CONFIG_NDK
#define KK_DB_FILE_SUB                  "kk/kk_database.db"
#define KK_LAN_NODE_DB_FILE_SUB 		"kk/kk_lan_node.db"
#elif CONFIG_A133_PLATFORM
#define KK_DB_FILE_SUB                  "kk/db/kk_database.db"
#define KK_LAN_NODE_DB_FILE_SUB 		"kk/db/kk_lan_node.db"
#else
#define KK_DB_FILE_SUB                  "kk/kk_database.db"
#define KK_LAN_NODE_DB_FILE_SUB 		"kk/kk_lan_node.db"
#endif
#define TSL_SUBDEVICE_PATH_FILE_SUB     "kk/tsl/product_%s.json"
#define TSL_GATEWAY_PATH_FILE_SUB       "kk/tsl/gateway_%s.json"
#define TSL_CCU_PATH_FILE_SUB           "kk/tsl/ccu_%s.json"
#define TSL_SCENE_PATH_FILE_SUB         "kk/tsl/ccu_%s_scene.json"
#define OTA_IMG_PATH_SUB                "OTA/"
#define OTA_IMG_FILE_SUB                "OTA/app_squashfs.img"
#define OTA_IMG_FILE_MD5_SUB            "OTA/app_squashfs.img.md5"

#define KK_CONFIG_FILE_PATH_SUB 		"kk/kk_cloud_conf.json"
#ifdef CONFIG_NDK
#define KK_DEFAULT_CONFIG_FILE_PATH_SUB 	"kk/cloud_default_config.json"
#elif CONFIG_A133_PLATFORM
#define KK_DEFAULT_CONFIG_FILE_PATH_SUB 	"kk/etc/cloud_default_config.json"
#endif
#define KK_AUTH_CONFIG_FILE_PATH_SUB 		"kk/auth_conf.json"



__attribute__((weak)) char KK_DEVICESECRET_PATH[128]	= STORSGE_DIR"/"KK_DEVICESECRET_PATH_SUB;
__attribute__((weak)) char KK_TOKEN_PATH[128]	= STORSGE_DIR"/"KK_TOKEN_PATH_SUB;
__attribute__((weak)) char KK_DEVICE_MAP_FILE_PATH[128] = STORSGE_DIR"/"KK_DEVICE_MAP_FILE_PATH_SUB;
__attribute__((weak)) char KK_DB_FILE[128] = STORSGE_DIR"/"KK_DB_FILE_SUB;
__attribute__((weak)) char KK_LAN_NODE_DB_FILE[128]	= STORSGE_DIR"/"KK_LAN_NODE_DB_FILE_SUB;
__attribute__((weak)) char TSL_SUBDEVICE_PATH_FILE[128] = STORSGE_DIR"/"TSL_SUBDEVICE_PATH_FILE_SUB;
__attribute__((weak)) char TSL_GATEWAY_PATH_FILE[128] = STORSGE_DIR"/"TSL_GATEWAY_PATH_FILE_SUB;
__attribute__((weak)) char TSL_CCU_PATH_FILE[128] = STORSGE_DIR"/"TSL_CCU_PATH_FILE_SUB;
__attribute__((weak)) char TSL_SCENE_PATH_FILE[128] = STORSGE_DIR"/"TSL_SCENE_PATH_FILE_SUB;
__attribute__((weak)) char OTA_IMG_PATH[128] = STORSGE_DIR"/"OTA_IMG_PATH_SUB;
__attribute__((weak)) char OTA_IMG_FILE[128] = STORSGE_DIR"/"OTA_IMG_FILE_SUB;
__attribute__((weak)) char OTA_IMG_FILE_MD5[128] = STORSGE_DIR"/"OTA_IMG_FILE_MD5_SUB;
__attribute__((weak)) char KK_CONFIG_FILE_PATH[128]	= STORSGE_DIR"/"KK_CONFIG_FILE_PATH_SUB;
#ifdef CONFIG_A133_PLATFORM
__attribute__((weak)) char KK_DEFAULT_CONFIG_FILE_PATH[128]	= STORSGE_DIR"/"KK_DEFAULT_CONFIG_FILE_PATH_SUB;
__attribute__((weak)) char KK_AUTH_CONFIG_FILE_PATH[128]	= STORSGE_DIR"/"KK_AUTH_CONFIG_FILE_PATH_SUB;
#else
__attribute__((weak)) char KK_DEFAULT_CONFIG_FILE_PATH[128]	= "/app/ccuApps/config/cloud_default_config.json";
__attribute__((weak)) char KK_AUTH_CONFIG_FILE_PATH[128]	= "/tmp/auth_conf.json";
#endif

enum {
    DEVICE_OFFLINE = 0,
    DEVICE_ONLINE,
    DEVICE_UNKNOW,
};






#endif
