#ifndef __KK_DM_MSG__
#define __KK_DM_MSG__
#include "kk_tsl_common.h"

#include "../tsl_handle/lite-cjson.h"


#define DM_MSG_KEY_ID                   "id"
#define DM_MSG_KEY_VERSION              "version"
#define DM_MSG_KEY_METHOD               "method"
#define DM_MSG_KEY_PARAMS               "params"
#define DM_MSG_KEY_CODE                 "code"
#define DM_MSG_KEY_DATA                 "data"
#define DM_MSG_KEY_MESSAGE              "message"

#define DM_MSG_VERSION                  "1.0"

#define DM_MSG_KEY_PRODUCT_KEY          "productKey"
#define DM_MSG_KEY_DEVICE_NAME          "deviceName"
#define DM_MSG_KEY_DEVICE_SECRET        "deviceSecret"
#define DM_MSG_KEY_TIME                 "time"


#define DM_MSG_SIGN_METHOD_SHA256       "Sha256"
#define DM_MSG_SIGN_METHOD_HMACMD5      "hmacMd5"
#define DM_MSG_SIGN_METHOD_HMACSHA1     "hmacSha1"
#define DM_MSG_SIGN_METHOD_HMACSHA256   "hmacSha256"


typedef struct {
    lite_cjson_t id;
    lite_cjson_t code;
    lite_cjson_t data;
    lite_cjson_t message;
} dm_msg_response_payload_t;


#ifndef DM_READ_ONLY
    #define DM_READ_ONLY
#endif
#define DM_MSG_VERSION                  "1.0"
const char DM_MSG_INFO[] DM_READ_ONLY;

#define KK_REGISTER_TOPIC_REPLY                   "/thing/sub/register_reply"
#define KK_ADD_TOPIC_REPLY                        "/thing/topo/add_reply"
#define KK_LOGIN_TOPIC_REPLY                      "/thing/combine/login_reply"
#define KK_ONLINE_TOPIC_REPLY                     "/thing/status/online_reply"
#define KK_THING_SERVICE_PROPERTY_SET             "/thing/service/property/set"
#define KK_THING_SERVICE_PROPERTY_GET             "/thing/service/property/get"
#define KK_THING_OTA_DEVICE_UPGRADE	              "/ota/device/upgrade"
#define KK_THING_CLOUDSTATE_MSG                   "/thing/ccu/cloudstate_reply"
#define KK_THING_TOPO_ADD_MSG                     "/thing/topo/add"
#define KK_THING_TOPO_BATCH_ADD_MSG               "/thing/topo/batch_add"
#define KK_THING_PROPERTY_POST                    "property/post"
#define KK_THING_TOPO_DELETE_MSG                  "/thing/topo/delete"
#define KK_THING_TOPO_BATCH_DELETE_MSG            "/thing/topo/batch_delete"
#define KK_THING_TOPO_CHANGE_MSG                  "/thing/topo/change"
#define KK_THING_SERVICE_REBOOT                   "/thing/service/reboot"
#define KK_THING_SERVICE_ADDROOM                  "/thing/service/addRoom"
#define KK_THING_SERVICE_DELETEROOM               "/thing/service/deleteRoom"
#define KK_THING_SERVICE_ADDDEVICETOROOM          "/thing/service/addDeviceToRoom"
#define KK_THING_SERVICE_REMOVEDEVICEFROMROOM     "/thing/service/removeDeviceFromRoom"
#define KK_THING_SERVICE_EXECUTEROOM              "/thing/service/executeRoom"
#define KK_THING_SERVICE_SETLOCALTIMER            "/thing/service/setLocalTimer"
#define KK_THING_SERVICE_GETLOCALTIMER            "/thing/service/getLocalTimer"
#define KK_THING_SERVICE_SETCOUNTDOWN             "/thing/service/setCountDown"
#define KK_THING_SERVICE_GETCOUNTDOWN             "/thing/service/getCountDown"
#define KK_THING_SERVICE_GETKEYLIST               "/thing/service/GetKeyList"
#define KK_THING_SERVICE_ADDKEY                   "/thing/service/AddKey"
#define KK_THING_SERVICE_DELETEKEY                "/thing/service/DeleteKey"
#define KK_THING_SERVICE_MODIFYKEY                "/thing/service/ModifyKey"
#define KK_THING_SERVICE_ADDSCENC                 "/thing/service/addScene"
#define KK_THING_SERVICE_DELETESCENC              "/thing/service/deleteScene"
#define KK_THING_SERVICE_UPDATESCENC              "/thing/service/updateScene"
#define KK_THING_SERVICE_PROPERTY_GET_REPLY       "/thing/service/property/get_reply"
#define KK_THING_SERVICE_EXECUTESCENE             "/thing/service/executeScene"
#define KK_THING_SERVICE_NEGATIVE             	  "/thing/service/negativeProperty"
#define KK_THING_METHOD_DELETESCENC               "thing.service.deleteScene"
#define KK_THING_METHOD_UPDATESCENC               "thing.service.updateScene"
#define KK_THING_METHOD_EXECUTESCENE              "thing.service.executeScene"
#define KK_THING_METHOD_ADDSCENC                  "thing.service.addScene"


#define KK_THING_EVENT_MESSAGE                    "/thing/event/"
#define KK_THING_EVENT_POST                       "/post"




//const char DM_URI_SYS_PREFIX[]                        DM_READ_ONLY = "/sys/%s/%s/";


#endif
